/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.whirlisprig;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WhirlisprigTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.goal.DistanceRestrictedGoal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class InspectPlantGoal
extends DistanceRestrictedGoal {
    Whirlisprig entity;
    BlockPos pos;
    int timeLooking;
    int timePerforming;

    public InspectPlantGoal(Whirlisprig entity, Supplier<BlockPos> from, int maxDistanceFrom) {
        super(from, maxDistanceFrom);
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.entity = entity;
    }

    public boolean hasVisibleSide(BlockPos pos) {
        for (Direction d : Direction.values()) {
            if (!this.entity.level.getBlockState(pos.relative(d)).isAir()) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.pos == null) {
            return;
        }
        --this.timePerforming;
        if (BlockUtil.distanceFrom(this.entity.blockPosition(), this.pos) > 1.5) {
            this.entity.getNavigation().moveTo((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), 1.2);
        } else {
            ServerLevel world = (ServerLevel)this.entity.level;
            this.entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()));
            if (world.random.nextInt(20) == 0) {
                world.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.1, (double)this.pos.getZ() + 0.5, 1, ParticleUtil.inRange(-0.2, 0.2), 0.0, ParticleUtil.inRange(-0.2, 0.2), 0.01);
            }
            --this.timeLooking;
        }
    }

    public boolean canContinueToUse() {
        return this.pos != null && this.timeLooking > 0 && this.timePerforming > 0;
    }

    public boolean canUse() {
        WhirlisprigTile tile = this.entity.getTile();
        if (tile != null && !tile.isOff) {
            if (this.entity.timeSinceGen > 300) {
                return true;
            }
            if (this.entity.getCommandSenderWorld().random.nextInt(100) <= 2) {
                return this.entity.level.getGameTime() % 10L == 0L;
            }
        }
        return false;
    }

    public void start() {
        int range = 4;
        ArrayList list = new ArrayList();
        BlockPos.betweenClosedStream((BlockPos)this.entity.blockPosition().offset(range, range, range), (BlockPos)this.entity.blockPosition().offset(-range, -range, -range)).forEach(bp -> {
            if (WhirlisprigTile.getScore(this.entity.level.getBlockState(bp)) > 0 && this.hasVisibleSide((BlockPos)bp) && this.isInRange((BlockPos)bp)) {
                list.add(bp.immutable());
            }
        });
        if (list.isEmpty()) {
            return;
        }
        this.pos = (BlockPos)list.get(this.entity.level.random.nextInt(list.size()));
        this.timeLooking = 120;
        this.timePerforming = 240;
        EntityFlyingItem.spawn(this.entity.flowerPos, (ServerLevel)this.entity.level, this.pos, this.entity.flowerPos, 50, 255, 40).getEntityData().set(EntityFlyingItem.HELD_ITEM, (Object)this.entity.level.getBlockState(this.pos).getBlock().asItem().getDefaultInstance());
        this.entity.timeSinceGen = 0;
        this.entity.getTile().addProgress();
    }
}

